/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.activate;

import com.ibm.hwmca.base.activate.ActivateErrorIDs;
import com.ibm.hwmca.base.activate.ActivationCTData;
import com.ibm.hwmca.base.activate.ActivationDataForApp;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.List;

public class ActivationCT
extends Task
implements ActivateErrorIDs {
    private static final String TRACE_MASKT = "XACTCT T";
    private static final String TRACE_MASKF = "XACTCT F";
    private static final String TRACE_MASKD = "XACTCT D";
    private static final String INTERFACE_NAME = "com.ibm.hwmca.base.activate.Activation";

    public ActivationCT(String name, UIInfo uiInfo) {
        super(name, uiInfo);
        Trace.trace(TRACE_MASKT, "<> ActivationCT(name = " + name + ") ");
    }

    public List checkTargets(PresentationTaskParms parms) {
        Trace.trace(TRACE_MASKT, "-> ActivationCT.checkTargets(PresentationTaskParms)");
        ActivationCTData actd = new ActivationCTData();
        ArrayList activationGroupTargetLists = new ArrayList();
        ArrayList badTargetsList = new ArrayList();
        actd.getGoodBadTargets(parms, activationGroupTargetLists, badTargetsList, this);
        actd.setTargetData(activationGroupTargetLists);
        Trace.trace(TRACE_MASKT, "<- ActivationCT.checkTargets() ");
        return badTargetsList;
    }

    public ManagedObject[] checkSecondaryTargets(PresentationTaskParms parms) {
        Trace.trace(TRACE_MASKT, "-> ActivationCT.checkSecondaryTargets() ");
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        ActivationCTData actd = new ActivationCTData();
        ArrayList targetData = actd.getTargetData(parms);
        ArrayList<ManagedObject> secondaryObjects = new ArrayList<ManagedObject>();
        ObjectId[] oids = parms.getTargetIds();
        ManagedObject[] targets = new ManagedObject[oids.length];
        for (int j = 0; j < oids.length; ++j) {
            HwmcaObject ho = mom.get(oids[j]);
            if (ho instanceof ManagedObject) {
                Trace.trace(TRACE_MASKT, " object [" + j + "] is a managed object");
                targets[j] = (ManagedObject)ho;
                continue;
            }
            Trace.trace(TRACE_MASKT, " object [" + j + "] is NOT a managed object");
            Trace.trace(TRACE_MASKT, " object is " + ho);
        }
        for (int i = 0; i < targets.length; ++i) {
            for (int j = 0; j < targetData.size(); ++j) {
                ActivationDataForApp[] ads = ActivationCTData.getTargetListForN(targetData, j);
                if (ads == null) continue;
                for (int k = 0; k < ads.length; ++k) {
                    ManagedObject[] sobs;
                    if (!ads[k].getManagedObject().equals(targets[i]) || (sobs = ads[k].getSecondaryObjects()) == null) continue;
                    for (int sobs_index = 0; sobs_index < sobs.length; ++sobs_index) {
                        boolean found_match = false;
                        for (int soList_index = 0; soList_index < secondaryObjects.size() && !found_match; ++soList_index) {
                            ManagedObject mo = (ManagedObject)secondaryObjects.get(soList_index);
                            if (sobs[sobs_index] != mo) continue;
                            found_match = true;
                        }
                        if (found_match) continue;
                        secondaryObjects.add(sobs[sobs_index]);
                    }
                }
            }
        }
        ManagedObject[] MOs = null;
        if (secondaryObjects.size() > 0) {
            MOs = new ManagedObject[secondaryObjects.size()];
            MOs = secondaryObjects.toArray(MOs);
        }
        if (MOs != null) {
            Trace.trace(TRACE_MASKT, "<- ActivationCT.checkSecondaryTargets() = " + MOs.length + " returned Secondary Objects");
        } else {
            Trace.trace(TRACE_MASKT, "<- ActivationCT.checkSecondaryTargets() = 0 returned Secondary Objects");
        }
        return MOs;
    }

    public LocalizableText[] getConfirmationTexts(ManagedObject[] targets) {
        Trace.trace(TRACE_MASKT, "-> ActivationCT.getConfirmationTexts() ");
        LocalizableText[] text = null;
        if (this.getName().equals("base.task.deactivate")) {
            text = new LocalizableText[targets.length];
            LocalizableText badObjectText = new LocalizableText(" ");
            ActivationCTData actd = new ActivationCTData();
            ArrayList targetData = actd.getTargetData(null);
            if (targetData != null) {
                Trace.trace(TRACE_MASKD, "  Got target data  ");
                int numObjects = 0;
                for (int j = 0; j < targetData.size(); ++j) {
                    ActivationDataForApp[] ads = ActivationCTData.getTargetListForN(targetData, j);
                    if (ads == null) continue;
                    numObjects += ads.length;
                }
                text = new LocalizableText[numObjects];
                for (int i = 0; i < targets.length; ++i) {
                    for (int j = 0; j < targetData.size() && text[i] == null; ++j) {
                        ActivationDataForApp[] ads = ActivationCTData.getTargetListForN(targetData, j);
                        if (ads == null) continue;
                        for (int k = 0; k < ads.length; ++k) {
                            if (!ads[k].getManagedObject().equals(targets[i])) continue;
                            text[i] = ads[k].getConfirmationText();
                            Trace.trace(TRACE_MASKD, "  Name = " + ads[k].getManagedObject().getName());
                            if (text[i] == null) continue;
                            Trace.trace(TRACE_MASKD, "  text[" + i + "] = " + text[i].toString());
                        }
                    }
                    if (text[i] != null) continue;
                    text[i] = badObjectText;
                }
            } else {
                for (int i = 0; i < text.length; ++i) {
                    text[i] = new LocalizableText("");
                }
                HException hexc = new HException("Error getting saved data");
                new FrameworkLog(ActivateErrorIDs.LOGINFO, 18183, hexc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- ActivationCT.getConfirmationTexts() ");
        return text;
    }

    public void updateTasksPerformed(PresentationTaskParms parms) {
        Trace.trace(TRACE_MASKT, "-> ActivationCT.updateTasksPerformed() ");
        if (this.getName().equals("base.task.deactivate")) {
            Trace.trace(TRACE_MASKF, "  Deactivate case; about to call super.updateTasksPerformed()");
            super.updateTasksPerformed(parms);
        }
        Trace.trace(TRACE_MASKT, "<- ActivationCT.updateTasksPerformed() ");
    }

    public void updateTasksPerformedAlways(PresentationTaskParms parms) {
        Trace.trace(TRACE_MASKT, "-> ActivationCT.updateTasksPerformedAlways() ");
        Trace.trace(TRACE_MASKD, "  PresentationTaskParms = " + parms);
        super.updateTasksPerformed(parms);
        Trace.trace(TRACE_MASKT, "<- ActivationCT.updateTasksPerformedAlways() ");
    }
}

